---@meta

---@class FMediaCaptureOptions
---@field bAutoRestartOnSourceSizeChange boolean
---@field OverrunAction EMediaCaptureOverrunAction
---@field Crop EMediaCaptureCroppingType
---@field ColorConversionSettings FOpenColorIOColorConversionSettings
---@field CustomCapturePoint FIntPoint
---@field ResizeMethod EMediaCaptureResizeMethod
---@field bSkipFrameWhenRunningExpensiveTasks boolean
---@field bConvertToDesiredPixelFormat boolean
---@field bForceAlphaToOneOnConversion boolean
---@field bApplyLinearToSRGBConversion boolean
---@field bAutostopOnCapture boolean
---@field NumberOfFramesToCapture int32
---@field CapturePhase EMediaCapturePhase
local FMediaCaptureOptions = {}



---@class FMediaIOAutoDetectableTimecodeFormat_Backup
---@field TimecodeFormat EMediaIOTimecodeFormat
---@field bAutoDetect boolean
local FMediaIOAutoDetectableTimecodeFormat_Backup = {}



---@class FMediaIOConfiguration
---@field bIsInput boolean
---@field MediaConnection FMediaIOConnection
---@field MediaMode FMediaIOMode
local FMediaIOConfiguration = {}



---@class FMediaIOConnection
---@field Device FMediaIODevice
---@field protocol FName
---@field TransportType EMediaIOTransportType
---@field QuadTransportType EMediaIOQuadLinkTransportType
---@field PortIdentifier int32
local FMediaIOConnection = {}



---@class FMediaIODevice
---@field DeviceName FName
---@field DeviceIdentifier int32
local FMediaIODevice = {}



---@class FMediaIOInputConfiguration
---@field MediaConfiguration FMediaIOConfiguration
---@field InputType EMediaIOInputType
---@field KeyPortIdentifier int32
local FMediaIOInputConfiguration = {}



---@class FMediaIOMode
---@field FrameRate FFrameRate
---@field Resolution FIntPoint
---@field Standard EMediaIOStandardType
---@field DeviceModeIdentifier int32
local FMediaIOMode = {}



---@class FMediaIOOutputConfiguration
---@field MediaConfiguration FMediaIOConfiguration
---@field OutputType EMediaIOOutputType
---@field KeyPortIdentifier int32
---@field OutputReference EMediaIOReferenceType
---@field ReferencePortIdentifier int32
local FMediaIOOutputConfiguration = {}



---@class FMediaIOVideoTimecodeConfiguration
---@field MediaConfiguration FMediaIOConfiguration
---@field TimecodeFormat EMediaIOAutoDetectableTimecodeFormat
local FMediaIOVideoTimecodeConfiguration = {}



---@class UBlendDeinterlacer : UVideoDeinterlacer
local UBlendDeinterlacer = {}


---@class UBobDeinterlacer : UVideoDeinterlacer
local UBobDeinterlacer = {}


---@class UCaptureCardMediaSource : UTimeSynchronizableMediaSource
---@field bRenderJIT boolean
---@field bFramelock boolean
---@field EvaluationType EMediaIOSampleEvaluationType
---@field Deinterlacer UVideoDeinterlacer
---@field InterlaceFieldOrder EMediaIOInterlaceFieldOrder
---@field bOverrideSourceEncoding boolean
---@field OverrideSourceEncoding EMediaIOCoreSourceEncoding
---@field bOverrideSourceColorSpace boolean
---@field OverrideSourceColorSpace ETextureColorSpace
---@field ColorConversionSettings FOpenColorIOColorConversionSettings
local UCaptureCardMediaSource = {}



---@class UDiscardDeinterlacer : UVideoDeinterlacer
local UDiscardDeinterlacer = {}


---@class UFileMediaCapture : UMediaCapture
local UFileMediaCapture = {}


---@class UFileMediaOutput : UMediaOutput
---@field WriteOptions FImageWriteOptions
---@field FilePath FDirectoryPath
---@field BaseFileName FString
---@field bOverrideDesiredSize boolean
---@field DesiredSize FIntPoint
---@field bOverridePixelFormat boolean
---@field DesiredPixelFormat EFileMediaOutputPixelFormat
---@field bInvertAlpha boolean
local UFileMediaOutput = {}



---@class UMediaCapture : UObject
---@field OnStateChanged FMediaCaptureOnStateChanged
---@field MediaOutput UMediaOutput
local UMediaCapture = {}

---@param RenderTarget UTextureRenderTarget2D
---@return boolean
function UMediaCapture:UpdateTextureRenderTarget2D(RenderTarget) end
---@param bAllowPendingFrameToBeProcess boolean
function UMediaCapture:StopCapture(bAllowPendingFrameToBeProcess) end
---@param InMediaOutput UMediaOutput
function UMediaCapture:SetMediaOutput(InMediaOutput) end
---@return EMediaCaptureState
function UMediaCapture:GetState() end
---@return FIntPoint
function UMediaCapture:GetDesiredSize() end
---@return EPixelFormat
function UMediaCapture:GetDesiredPixelFormat() end
---@param RenderTarget UTextureRenderTarget2D
---@param CaptureOptions FMediaCaptureOptions
---@return boolean
function UMediaCapture:CaptureTextureRenderTarget2D(RenderTarget, CaptureOptions) end
---@param CaptureOptions FMediaCaptureOptions
---@return boolean
function UMediaCapture:CaptureActiveSceneViewport(CaptureOptions) end


---@class UMediaIOCoreSubsystem : UEngineSubsystem
local UMediaIOCoreSubsystem = {}


---@class UMediaOutput : UObject
---@field NumberOfTextureBuffers int32
local UMediaOutput = {}

---@param OutFailureReason FString
---@return boolean
function UMediaOutput:Validate(OutFailureReason) end
---@return UMediaCapture
function UMediaOutput:CreateMediaCapture() end


---@class UVideoDeinterlacer : UObject
local UVideoDeinterlacer = {}


